<?php
/**
 * OnGetSellingUnitAvailableQuantityListener.php 2020-3-20
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

namespace Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Listeners;

use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeModifierIdentifier;
use Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Services\ReaderServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitAvailableQuantityEventInterface;

class OnGetSellingUnitAvailableQuantityListener
{

    /**
     * @var ReaderServiceInterface
     */
    protected $service;

    /**
     * OnGetSellingUnitAvailableQuantityListener constructor.
     * @param ReaderServiceInterface $service
     */
    public function __construct(ReaderServiceInterface $service)
    {
        $this->service = $service;
    }

    /**
     * @param OnGetSellingUnitAvailableQuantityEventInterface $event
     *
     * @return OnGetSellingUnitAvailableQuantityEventInterface
     */
    public function __invoke(OnGetSellingUnitAvailableQuantityEventInterface $event
    ): OnGetSellingUnitAvailableQuantityEventInterface {
        foreach ($event->id()->modifiers() as $modifierId) {
            if ($modifierId instanceof AttributeModifierIdentifier) {
                $quantity = $this->service->getQuantity($event->id()->productId(), $modifierId, $event->product());
                $event->addQuantity($quantity);
            }
        }
        return $event;
    }
}